﻿IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Cliente_Xcampo]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Cliente_Xcampo] 
END
GO

CREATE PROCEDURE [dbo].[CP_Cliente_Xcampo]   @pId_Cliente	INT
AS
SET NOCOUNT ON




CREATE TABLE #ClienteXCampo (Id_Campo INT, Etiqueta VARCHAR(200), Valor VARCHAR(8000), TipoDato VARCHAR(100), Flag_Logico TINYINT)


DECLARE @Id_Campo	INT
DECLARE @Etiqueta	VARCHAR(200)
DECLARE @Valor		VARCHAR(8000)
DECLARE @TipoDato	VARCHAR(100)
DECLARE @Flag_Logico TINYINT

DECLARE curClientesXCamposListar CURSOR FOR
SELECT Id_Campo, Etiqueta, TipoDato, Flag_Logico
FROM xCampos
WHERE
ISNULL(Flag_Clientes, 0) = 1
AND Flag_Web=1
ORDER BY Orden

OPEN curClientesXCamposListar
FETCH NEXT FROM curClientesXCamposListar INTO @Id_Campo, @Etiqueta, @TipoDato, @Flag_Logico
WHILE @@FETCH_STATUS = 0
BEGIN

	SET @Valor = dbo.CF_Cliente_xCampo(@pId_Cliente, @Id_Campo)

	IF(@Flag_Logico = 1)
	BEGIN
		IF(@Valor = 1)
		BEGIN
			SET @Valor = 'X'
		END
		ELSE
		BEGIN
			SET @Valor = ''
		END
	END

	INSERT INTO #ClienteXCampo 
	(Id_Campo, Etiqueta, Valor, TipoDato, Flag_Logico) 
	VALUES 
	(@Id_Campo, @Etiqueta, @Valor, @TipoDato,@Flag_Logico)

	FETCH NEXT FROM curClientesXCamposListar INTO @Id_Campo, @Etiqueta, @TipoDato, @Flag_Logico
END
CLOSE curClientesXCamposListar
DEALLOCATE curClientesXCamposListar


SELECT * FROM #ClienteXCampo
DROP TABLE #ClienteXCampo

RETURN 0
